
#ifndef _NVDDEMO_H
#define _NVDDEMO_H

#include <iostream>
#include <iomanip>
#include <string>
#include <vector>
#include <map>
#include <errno.h>
#include <pthread.h>
#include <unistd.h>

#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

using namespace std;

#include "CLS_NVDSDKHelper.h"
#include "ActionControl.h"

typedef struct
{
	unsigned short  FrameRate;
	unsigned short  Width;
	unsigned short  Height;
	unsigned char   usReserved1[2];
	unsigned char	usReserved2[68];
	unsigned int    SamplesPerSec; //ʣĬ8000
	unsigned char	usReserved3[8];
}S_header;

typedef struct
{
	unsigned int	u32FrameID; 
	unsigned int	u32FrameSize;	//֡С32λ֡Сֽ
	unsigned char	usReserved1[24];
}S_FrameHeader;

typedef bool (*pGetControlCode)(int _iAction,Data_t *_pData);
typedef int  (*pReleaseCtrl)();

struct st_PushStream
{
	long    m_lPushID;
	FILE    *m_pFile;
	FILE    *m_pReadFile;
	int     m_bStart;
	int		m_iSpeed;
	bool	m_bFlagAudio;
	pthread_t m_tdSend;
};

struct st_Decoder
{
	char m_cIP[32];
	int  m_iPort;
	st_PushStream   m_stPush[DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM][DEC_MAX_PICTURE_NUM];
	st_Decoder()
	{
		memset(m_cIP,0,sizeof(m_cIP));
		m_iPort = 3000;
		for(int i=0; i<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; i++)
			for(int j=0; j<DEC_MAX_PICTURE_NUM; j++)
			{
				m_stPush[i][j].m_lPushID = -1;
				m_stPush[i][j].m_pFile = NULL;
				m_stPush[i][j].m_bStart = 0;
				m_stPush[i][j].m_iSpeed = 0;
				m_stPush[i][j].m_bFlagAudio = false;
				m_stPush[i][j].m_tdSend = 0;
			}
	};
};

//---------------------------------------------------------------------------

typedef class st_NextItem
{
public:
	int m_iDecID;
	int m_iChan;
	int m_iPic;

	TNVSITEMEX m_viewItemEx;           //˫ʱҪӵķ
	st_NextItem()
	{
		m_iDecID = -1;
		m_iChan = -1;
		m_iPic = -1;
		memset(&m_viewItemEx, 0, sizeof(TNVSITEMEX));
		m_viewItemEx.m_iStructLen = sizeof(TNVSITEMEX);
	}

	~st_NextItem()
	{
		m_iDecID = -1;
		m_iChan = -1;
		m_iPic = -1;
		memset(&m_viewItemEx, 0, sizeof(TNVSITEMEX));
	}

}NVSINFO, *pNVSINFO;


//int to string
string  IntToStr(int _itemp);

//
int MajorProc(bool _bStart = true);
//Ҳļʵ
int MakeCMD();
//SDKİ汾Ϣ
int ShowSDKVersion();
//İ汾Ϣ
int ShowDecVersion(int _iID);
//½
int LogonDec(int &_iID, char *_pcIP = NULL,bool _bLogin = false);
//ǳ
int LogoutDec(int iID = -1);

//شϢ
int MyPostMsg(void *_hWnd, unsigned int _uiMsg, unsigned int _wParam, int _lParam);
void ComRecvNotify(long _iID, char *_pcBuf, int _iLength);

//е½ĽID
int ListAllLogin();

//logϢ
int ShowLog(string _strlog, bool bWrFile = false);

//ָӵNVSϢ
int ShowNVSInfo(int _iID = -1, int _iChan = -1, int _iPos = -1);

//ʾϢ
int ShowDECInfo();
//ʾѵ½ĽϢ
int ShowAllDECInfo();

//ýIP
int SetDECIP();
//ýDDNS
int SetDDNS();
//ý
int SetCom();
//ñ
int SetAlarm();
//TVϢ
int SetTV();
//ͨ
int SetChannel();
//logo
int SetLogo();
//logoϢ
int GetLogo();
//VGAС
int SetVGASize();

//ʼ
int StartView();
//ֹͣ
int StopView();
//ʼл
int StartLoop();
//ֹͣл
int StopLoop();

//NVS
int AddNVS();
//޸NVSϢ
int ModifyNVS();
//ɾָNVS
int DelNVS(int _iID = -1, int _iChannel = -1, int _iPos = -1, int _iNVSIndex = -1);

//Ƶ
int StartAudio();
//رƵ
int StopAudio();
//̨
int PTZCtrl();
//485
int DEC485Ctrl();
//ʼԽ
int StartTalk();
//رնԽ
int StopTalk();
//
int RebootDec(int _iID = -1);
//ָ
int ResetDec(int _iID = -1);

//ں
int UpgradeKernel();
//LOGO
int UpgradeLogo();
//Э
int UpgradeProtocol();
//Ƕҳ
int UpgradeWeb();
//ɾЭ
int DeleteProtocol();

//󲢷
int StartPushStream();
//ֹͣ
int StopPushStream();

//ý
int GetCapability(int _iID = -1);

//¼ӵNVSϢ
int RecordNVSInfo();

//оٿЭ
int ListProtocol();

/**************************20121101-->add by wangshaobo***************************/
//
//int PushStreamToDecoder();
//ȡ״̬
int GetStreamBufferState();
int StreamControl();
//ʼ
int ConnectAllPushVideo();
//NVS
int AddNVS_Ex();
int StartPushStreamEx();
int SetVolume();
int SetPreviewPreference();
int SetNetCutHoldLastFrame();
int StopPushStreamEx();
int StartPushStream_V1();
int CutAllPushVideo();
int GetChannelState();
int SetAlarmLinkSwitch();
int GetAlarmLinkSwitch();
int CreateVVO();
int ShowVVOInfo();
int SetSplitScreen();
int ShowSplitScreenInfo();
int SetAlarmSchedule();
int GetAlarmSchedule();
int SetAlarmLink();
int GetAlarmLink();
int SetAlarmInAndOut();
int GetAlarmInAndOut();
int GetAlarmNotify();
int SetScheduleEnable();
int GetScheduleEnable();
int SelectPicture();

#endif
