#ifndef __DECCTRLCLIENT_TYPES_H__
#define __DECCTRLCLIENT_TYPES_H__

#include "GlobalTypes.h"
#include "net_sdk_types.h"

#ifndef X_API
#if !defined(__WIN__)
#define X_API
#define STDCALL
#else
#define X_API __declspec(dllexport)
#define STDCALL __stdcall
#endif
#endif

typedef void (__stdcall *DEC_COMRECV_NOTIFY)(long _ulID, char *_cBuf, int _iLength);
//Ϣص
typedef int (*pTDPostMessage)(void *_hWnd, unsigned int _uiMsg, unsigned int _wParam, int _lParam);
typedef int (*pTDPostMessageEx)(void *_hWnd, unsigned int _uiMsg, unsigned int _wParam, int _lParam, void* _lpUserData);


#define NVD_HEAVY_MODE			0
#define NVD_LIGHT_MODE			1

#define DEC_LEN_8		8
#define DEC_LEN_16		16
#define DEC_LEN_32		32
#define DEC_LEN_64		64
#define DEC_LEN_128		128
#define DEC_LEN_256		256
#define DEC_LEN_512		512
#define DEC_MAX_CHANNELID_LEN   32             //ͨID

/**********************************************abandon************************************************/
#define	DEC_MAX_CHANNEL_NUM				8     //ÿͨ
#define	DEC_MAX_CHANNEL_NUM_NEW			16     //ÿͨ·չ16ͨ
#define	DEC_MAX_VIRTUAL_CHANNEL_NUM		8      //ÿͨʹ,ͨŴ16ʼ
#define DEC_MAX_SPLIT_SCREEN_NUM		16		//ķ

#define DEC_MAX_FLOAT_WINDOW_NUM 16
#define DEC_MAX_PICTURE_NUM		100             //ÿͨ໭չ100
#define DEC_MAX_WINDOW_TOTAL_NUM        (DEC_MAX_PICTURE_NUM + DEC_MAX_FLOAT_WINDOW_NUM)

#define	DEC_MAX_PHYSICAL_CHANNEL_NUM 	96  //ͨ
#define DEC_MAX_SPLIT_CHANNEL_NUM       48  //ƴͨ

#define DEC_MAX_CHANNEL_TOTAL_NUM       (DEC_MAX_PHYSICAL_CHANNEL_NUM + DEC_MAX_SPLIT_CHANNEL_NUM)

#define DEC_MAX_ENCODE_CHANNEL_NUM		48

typedef struct tagGetSipVideoChannel_Ex
{
	int		m_iBuffSize;	
	int     m_iBeginChannelNo;
	int		m_iChannelCount;
	char	m_cChannelID[DEC_MAX_CHANNEL_NUM_NEW][DEC_MAX_CHANNELID_LEN+1];
	int	    m_iLevel[DEC_MAX_CHANNEL_NUM_NEW];
	int 	m_iPtzTime[DEC_MAX_CHANNEL_NUM_NEW];
}GetSipVideoChannel_Ex, *pGetSipVideoChannel_Ex;

//ȡͨÿͨĻ
typedef struct tagChnNumAndMode
{
	int			iBufSize;				//ṹС
	int			iLocalChnNum;			//ͨ
	int			iVOChnNum;				//ƴͨ
	int			iLocalChnMode[DEC_MAX_CHANNEL_NUM_NEW];
	int			iVOChnMode[DEC_MAX_VIRTUAL_CHANNEL_NUM];
}ChnNumAndMode, *pChnNumAndMode;

typedef struct tagDecTimezone
{
	int iTimezone;
}DecTimezone, *PDecTimezone;

typedef struct tagDecScreenDisplay
{
	int iDisplay;
}DecScreenDisplay, *PDecScreenDisplay;
/*****************************************************************************************************/

#define DEC_MAX_NVSITEM_NUM     256             //ÿNVS
#define DEC_MAX_DECODER         128				//ӽ
#define DEC_MAX_COM_NUM			2				//󴮿
#define DEC_MAX_COM_NUM_NEW		8				//󴮿()
#define DEC_MAX_USER_NUM		32				//û

#define DEC_MAX_ALARM_OUT 7
#define DEC_MAX_ALARMMODE 1
#define DEC_MAX_IS_PAL	  1
#define DEC_MAX_LANGUAGE  1

#define NVS_MAX_CHANNEL_NUM		320				//豸ͨչ64ݴ·nvr

//Ϣ
#define DEC_WCM_DEC_LOGON         1   //¼״̬Ϣ
#define DEC_WCM_NVS_STARTVIEW     2   //NVSϢ
#define DEC_WCM_DEC_TALK          3   //ԽϢ

#define DEC_WCM_DEC_UPGRADE       4   //Ϣ
#define DEC_WCM_DEC_UPGRADELOGO   5   //LogoϢ
#define DEC_WCM_DEC_UPGRADEP      6   //ЭϢ

#define DEC_WCM_ERR_ORDER         7   //㷢
#define DEC_WCM_NVS_STOPVIEW      8   //ϿNVSϢ
#define DEC_WCM_DEC_PARASET       9   //ıϢ

#define DEC_WCM_DEC_UPGRADEWEB      10  //ҳϢ
#define DEC_WCM_DEC_UPGRADEPROCESS  11  //
#define DEC_WCM_DEC_AUDIOSTATUS     12  //Ƶ״̬Ϣ
#define DEC_WCM_DEC_TALK_FAILED     13  //add by lpy for Խʧ
#define DEC_WCM_DEC_AUDIO_FAILED    14  //add by lpy for Ƶʧ[2/5/2010 Administrator]

#define DEC_WCM_DEC_PUSHSTREAM		20	//Push stream 
#define DEC_WCM_ERR_PUSHSTREAM		21	//Push stream Ͽ
#define DEC_WCM_ERR_DATANET         22  //ͨ쳣

#define DEC_WCM_ERR_USERPASS		25	//޸
#define DEC_WCM_DETECT_CHANN_STATE	26	//ͨ״̬
#define DEC_WCM_ALARM_NOTIFY		27	//ϱ
#define DEC_WCM_PARASET_CREATEVVO	28  //ƴͨϢ

#define DEC_WCM_AUTOTEST_INFO		29  //Զ 

#define DEC_WCM_QUERY_LOG_FINISH	30  //־ѯ

#define DEC_WCM_NVS_STARTVIEW_FAILED      31   //NVSʧϢ

#define DEC_WCM_SEARCH_IPC			32   //IPC
#define DEC_WCM_SEARCH_NVD			33   //ֽ

#define DEC_WCM_CLUSTER_STATE 					34  
#define DEC_WCM_CLUSTER_CONTROL_CARD_STATE 		35
#define DEC_WCM_CLUSTER_WORK_CARD_STATE 		36
#define DEC_WCM_EXPORT_CONFIG_FINISH 			37
#define DEC_WCM_ENCODE_CHANNEL_STATE 			38
#define DEC_WCM_LOG_WRITE			 			39
#define DEC_WCM_EXCEPTION			 			40
#define DEC_WCM_DEC_USER_NUM					41
#define DEC_WCM_DEC_USER_INFO					42
#define DEC_WCM_DEC_LAST_ERROR					43
#define DEC_WCM_DEC_PICSNAP						44
#define DEC_WCM_DEC_GETPICFILENAME				45
#define DEC_WCM_DEC_SCREENCTLSET				46
#define DEC_WCM_DEC_REBOOTTRADE					47
#define DEC_WCM_DEC_GETUDISK_VIDEOLISTS			48
#define DEC_WCM_DEC_VIDEO_PLAYSET				49


//encodemode: 
//0H.2641MJPEG 23:H265, 31:MPEG4 100PS
#define ENCODE_H264			0
#define ENCODE_MJPEG		1
#define ENCODE_H265			23
#define ENCODE_MPEG4		31
#define ENCODE_PS			100

//videosize: ƵС
enum
{
	VIDEO_QCIF		= 0,			//Quarter Cif 	172*144, 
	VIDEO_HCIF		= 1,			//Half Cif	352*144 
	VIDEO_FCIF		= 2,			//Full Cif	352*288
	VIDEO_HD1		= 3,			//Half D1	704*288
	VIDEO_FD1		= 4,			//Full D1	704*576
	VIDEO_MD1		= 5,
	VIDEO_QVGA      = 6,            //QVGA      320x240
	VIDEO_VGA		= 7,			//VGA       640*480
	VIDEO_HVGA	    = 8,	        //HVGA      640*240
	VIDEO_HD_720P	= 9,			//720p      1280*720
	VIDEO_HD_960P	= 10,			//960P		1280*960
	VIDEO_HD_QXVGA	= 11,			//QXVGA		1600*1200
	VIDEO_HD_1080P	= 12,			//1080P		1920*1080
	VIDEO_HD_QXGA	= 13,			//300W		2048*1536
	VZ_4M           = 0x0210,		//400W		2560*1440
	VZ_4MB			= 0x0220,		//400WB		2592*1520
	VZ_QSXGA		= 0x500,		//500W(3)	2560*2048
	//ģʽ
	F720P_9_16		= 0x100009,		//720x 1280
	F1080P_9_16		= 0x10000C,		//1080x 1920
	F4M_9_16		= 0x100210,		//1440x2560
	F4MB_9_16		= 0x100220,		//1520x2592
	VIDEO_BUTT
};

#define VIDEO_SIZE_DEFAULT 255



#ifndef EMBEDED_USE
//VGAֱ
enum
{
	VGA_800X600		= 1,	//800*600 60HZ
	VGA_1024X768	= 2,	//1024*768 60HZ
	VGA_1280X1024	= 3,	//1280*1024 60HZ
	VGA_1280X720P_60,
	VGA_1920X1080P_60,
	VGA_1280X720P_50,
	VGA_1920X1080P_50,
	VGA_1920X1080I_60,
	VGA_1920X1080I_50,
	VGA_1366x768_60,
	VGA_1440x900_60,
	VGA_1280x800_60,
	VGA_2560x1600_30,
	VGA_3840x2160_30,
	VGA_3840x2160_60,
	VGA_BUTT,
};
#endif

#ifndef VGA_BUTT
#define VGA_BUTT	13
#endif

//¼״̬
enum
{
    DEC_LOGON_RETRY         = 2,
    DEC_LOGON_SUCCESS       = 0,
    DEC_LOGON_ING           = 1,
    DEC_LOGON_FAILED        = -1,
    DEC_LOGON_TIMEOUT       = -2,
    DEC_NOT_LOGON           = -3,
};

//Login failed error code
#define DEC_UNKNOW_ERROR			0
#define DEC_CIPHER_USERNAME_ERROR	1
#define DEC_CIPHER_USERPASS_ERROR	2
#define DEC_NO_SUPPORT_ALGORITHM	3
#define DEC_PSWD_ERR_TIMES_OVERRUN	4
#define DEC_ILLEGAL_PLATFORM        5

/************************************************************************
* SIPЭ                                                                     
************************************************************************/


typedef struct
{
	int  	m_iChannelNo;
	char 	m_cChannelID[DEC_MAX_CHANNELID_LEN+1];
	int     m_iLevel;
	int     m_iPtzTime;
} TSetSipVideoChannel;

typedef struct 
{
	int     m_iBeginChannelNo;
	int		m_iChannelCount;
	char	m_cChannelID[DEC_MAX_CHANNEL_NUM][DEC_MAX_CHANNELID_LEN+1];
	int	    m_iLevel[DEC_MAX_CHANNEL_NUM];
	int 	m_iPtzTime[DEC_MAX_CHANNEL_NUM];
} TGetSipVideoChannel;

typedef struct tagSipVideoChannel
{
	int		iSize;
	char 	cChannelID[DEC_MAX_CHANNELID_LEN+1];
	int     iLevel;
	int     iPtzTime;
}SipVideoChannel, *PSipVideoChannel;

#define DEC_MAX_LAN_NUM 2   //
typedef struct tagIPAddress
{
	char			ip[16];			//IPַ
	char			submask[16];		//
	char			gateway[16];		//صַ
	char			dns[16];			//DNSַ
}IPAddress, *pIPAddress;

typedef struct tagMacAddress
{
	char			cMac[18];			//ַ
}MacAddress, *pMacAddress;

/*=======================================*/
typedef struct
{
	char			m_ip[16];			//IPַ
	char			m_submask[16];		//
	char			m_gateway[16];		//صַ
	char			m_dns[16];			//DNSַ

	MacAddress		m_tMacAddress[DEC_MAX_LAN_NUM];			//ַ

	char			m_ddnsIP[16];		//IPַ
	char			m_ddnsUser[16];		//û
	char			m_ddnsPass[16];		//
	unsigned short	m_ddnsPort;			//˿
	unsigned char	m_ispal;			//0:PAL1:NTSC
	unsigned char	m_language;			//0:ģ1:Ӣ

	unsigned char	m_rs485type[DEC_MAX_COM_NUM];			//485ЭID0͸ͨ1:Pelco-P...
	unsigned char	m_rs485address[DEC_MAX_COM_NUM];		//485ַȡֵΧ0-255
	int				m_rs485baudrate[DEC_MAX_COM_NUM];		//485240048009600
	unsigned char	m_rs485databit[DEC_MAX_COM_NUM];   		//485λĬΪ8
	unsigned char	m_rs485stopbit[DEC_MAX_COM_NUM];		//485ֹͣλĬΪ1
	unsigned char	m_rs485checkbit[DEC_MAX_COM_NUM]; 		//485Уλֿѡ0У飻1У飻2żУ飻3̶Ϊ14̶Ϊ0
	unsigned char	m_rs485flowcontrol[DEC_MAX_COM_NUM];	//485أĬΪأЧ

	int				m_Alarmout;								//ϵ&0x01:˿ڱ&0x02:ʧ&0x04:ƶ1ʾ0ʾ
    int			    m_AlarmMode;							//ģʽ0͵ƽ1ߵƽ
	int				m_iChannel;								//ͨ0-8
	int				m_iComNumber;							//0-1
	unsigned char	m_nChanMode[DEC_MAX_CHANNEL_NUM];		//ÿͨĹģʽ1棻4Ļ棩

	int             m_iVGASize[DEC_MAX_CHANNEL_NUM];		//ÿͨVGAֱʣ1800*600 60Hz21024*768 60Hz31280*1024 60HzΪBNCͨòЧ
#ifdef __WIN__
	char			m_cRegSvrIP[32];
	int				m_iRegSvrPort;
	int				m_iRegSvrEnable;

	char			m_cPUID[21];							//	
	char			m_cPUName[DEC_LEN_32+1];



	int				m_iVolume;				//	

	int				m_iSelPic[2];			//	ѡ                           
//.................SIP.....@cmz..110223
	DZ_INFO_PARAM	m_dzInfoParam;
	TGetSipVideoChannel m_SipVideoChannel;
	//................Ƶ.....
	STR_VideoParam  m_VideoParam[DEC_MAX_CHANNEL_NUM];
	int				m_iRegChannelNum[2];
	char			m_cRegChannelPUID[2][DEC_LEN_32+1];
#endif
}TDECPARAM;

#define RTSP_URL_LEN	81
/*Ƶͨ======================================*/
typedef struct
{
	union
	{
		char				m_cRTSPUrl[RTSP_URL_LEN+1];		//RTSPַ
		struct  
		{
			char 			m_serName[33];		//(ʱ)
			char 			m_serIP[33];		//ַIPַҲ       zyp modified 0506
			char			m_serProxy[16];		//ϼ
		};		
	};
	
	unsigned char	m_serChan;			//ͨ
	unsigned char	m_serStream;		//
	unsigned char	m_serNetmode;		//Э1TCP2UDP3ಥ
	unsigned char	m_bUseddns;			//ͨ
	unsigned short	m_serPort;			//˿
	int				m_bisView;			//ǰǷ״̬1״̬0δ״̬(ʱʹ)
	char		   	m_username[20];		//û
	char	       	m_password[20];		//
	int         	m_holdtime;			//ʱ䣬ȡֵΧ5DD1000
    char            m_deviceType[16];   //豸Э飨Ҫ뵽Э飩
    unsigned char   m_iAddress;         //NVS豸ַȡֵΧ0-255
} TNVSITEM;

//Ƶͨչ
#define MAX_ENCYPTPWD_LEN	16
typedef struct __tagTNVSITEMEX
{
	int				m_iStructLen;							//ԺҪչԸжչֶε
	TNVSITEM		m_stOldItem;
	char			m_cEncyptPWD[MAX_ENCYPTPWD_LEN + 1];	//
	int				m_iDevPlatType;							//豸ƽ̨ͣ0-ͨ1-Onvif 2-push 3-RTSP
	void*			m_pvReserved;							//Ϊ˱չ
	char			m_cMultIP[33];							//鲥ַЭ
	int				m_iMultPort;							//鲥˿ں
	int             m_isavecfg;                             //ñ־
}TNVSITEMEX, *LPTNVSITEMEX;

/*ֵ֧Эб===============================*/
typedef struct
{
	int		m_iCount;					//ֵ֧Э
	char 	m_cProtocol[LEN_128][LEN_16];		//Эƣ֧128Э飬ÿЭ15ֽڣ
} TDECPROTOCOL;

/*SDK汾Ŷ==========================================*/
typedef struct
{
	unsigned short	m_ulMajorVersion;
	unsigned short	m_ulMinorVersion;
	unsigned short  m_ulBuilder;
	char*			m_cVerInfo;
}NVDSDK_VERSION;

/*OSDLogoԶ====================================*/
typedef struct
{
    unsigned char m_enable;           //ǷLogo
    int           m_iPosX;            //Logo
    int           m_iPosY;            //Logo
    unsigned char m_iAlpha;           //͸(0~100)100Ϊȫ͸
    int           m_iTransparentColor;//ɫRGBʽ(0x00000000~0x00ffffff)
}TLOGOPARAM;


/*豸֧ƽ̨Ϣ====================================*/
typedef struct  
{
	int     m_iCount;                 //ֵ֧ƽ̨Ŀ
	char    m_cPlatformName[10][32];  //ƽ̨       
}TPLATFORMINFO;

/*붨=============================================*/
#define ERR_SUCCESS					0		//ɹ
#define ERR_ISVIEW					1       //ӵNVS
#define ERR_INVALIDID				-1		//ָĽ
#define ERR_UNINIT					-2		//δʼ/ʼʧ
#define ERR_INVALIDPARA				-3		//Ƿ
#define ERR_INVALIDFILE				-7		//ļʽǷ
#define ERR_NOTLOGON				-8      //ûе¼
#define ERR_MAXDEC					-10     //ﵽ
#define ERR_FORBID					-12     //
#define ERR_RELOOPITEM				-13     //ѭбظ
#define ERR_NOCONNECTED				-16		//ûн
#define ERR_POS_X_Y					-17		//Ƿ
#define ERR_NULL_PTR				-18		// null pointer
#define ERR_UNDEFINED_BEHAVIOR		-19		// undefined behavior
#define ERR_INVALID_BUFF_SIZE		-20		//ϷĻС
#define ERR_INVALID_ARRAY_INDEX		-21		//Ϸ±
#define ERROR_INVALID_PARAM			-22		//Ϸ
#define ERR_REPEAT_SET				-23		//ظ
#define ERR_BUILD_PROTOCOL			-24		//build protocol error
#define ERR_SEND_PROTOCOL			-25		//send protocol error
#define ERR_NO_IDLE_ITEM			-26		//no idle item
#define ERR_INVALID_FILEHEADER		-27		//invalid file header
#define ERR_LIGHTMODE_NOTSUPPORT	-28		//sdk light mode not support
#define ERR_OUT_OF_MEMERY			-29		//sdk out of memery

/*붨=============================================*/
#define DECKEYCODE_NUM1     0X01
#define DECKEYCODE_NUM2		0X02
#define DECKEYCODE_NUM3		0X03
#define DECKEYCODE_NUM4		0X04
#define DECKEYCODE_NUM5		0X05
#define DECKEYCODE_NUM6		0X06
#define DECKEYCODE_NUM7		0X07
#define DECKEYCODE_NUM8		0X08
#define DECKEYCODE_NUM9		0X09
#define DECKEYCODE_NUM0		0X0A

#define DECKEYCODE_UP		0X0D    //
#define DECKEYCODE_DOWN		0X0E    //
#define DECKEYCODE_LEFT		0X0F    //
#define DECKEYCODE_RIGHT	0X10    //
#define DECKEYCODE_PAGEUP	0X11    //Ϸҳ
#define DECKEYCODE_PAGEDOWN	0X12    //·ҳ
#define DECKEYCODE_EDIT		0X13    //༭
#define DECKEYCODE_ESC		0X14    //ȡ
#define DECKEYCODE_RETURN	0X15    //ȷ
#define DECKEYCODE_ABC		0X16    //뷨л
#define DECKEYCODE_DEV		0X17    //DEV
#define DECKEYCODE_F1		0X18    //F1  
#define DECKEYCODE_F2		0X19    //F2

#define DECKEYCODE_MENU		0X20    //˵

#define DECKEYCODE_STOP		0X52	//ֹͣ(ʱ)

#ifndef EMBEDED_USE
/*̨붨===========================================*/
#define PTZ_LEFT			0	//left
#define PTZ_RIGHT			1
#define PTZ_UP				2
#define PTZ_DOWN			3
#define PTZ_IRISADD			4
#define PTZ_IRISDEC			5
#define PTZ_FOCUSADD		6
#define PTZ_FOCUSDEC		7
#define PTZ_ZOOMADD			8
#define PTZ_ZOOMDEC			9
#define PTZ_GOTOPOINT		10
#define PTZ_SETPOINT		11
#define PTZ_AUTO			12
#define PTZ_STOP			13
#define PTZ_LEFTSTOP		14
#define PTZ_RIGHTSTOP		15
#define PTZ_UPSTOP			16
#define PTZ_DOWNSTOP		17
#define PTZ_IRISADDSTOP		18
#define PTZ_IRISDECSTOP		19
#define PTZ_FOCUSADDSTOP	20
#define PTZ_FOCUSDECSTOP	21
#define PTZ_ZOOMADDSTOP		22
#define PTZ_ZOOMDECSTOP		23
#define PTZ_LIGHT			24
#define PTZ_LIGHTSTOP		25
#define PTZ_RAIN			26
#define PTZ_RAINSTOP		27
#define PTZ_TRACK			28
#define PTZ_TRACKSTOP		29
#define PTZ_DEVOPEN			30
#define PTZ_DEVCLOSE		31
#define PTZ_AUTOSTOP		32
#define PTZ_CLEARPOINT		33
#endif

//	豸ƽ̨
#define	DEVTYPE_NORMAL			0
#define	DEVTYPE_ONVIF			1
#define	DEVTYPE_PUSH			2
#define	DEVTYPE_RTSP			3
#define DEVTYPE_ENCODE			4
#define DEVTYPE_LOCAL           5
#define DEVTYPE_LG				1001
#define DEVTYPE_PANASONIC		1002

//	ͨҵ
#define COMMONID_NETCUT_HOLD_LASTFRAME	0x13001
#define COMMONID_PREVIEW_PREFERENCE		0x13002
#define COMMONID_HD_DISPLAY				0x13003
#define COMMONID_TELNET					0x13004 //ʹtelnet

//
#define PUSH_STREAM_CMD_TYPE	0
#define PUSH_STREAM_CMD_PAUSE	0
#define PUSH_STREAM_CMD_FAST	1
#define PUSH_STREAM_CMD_SLOW	2

//pushͣ״̬
#define PUSH_REAL_TIME_STREAM_STATE		0x100	//ʵʱ
#define PUSH_PLAYBACK_STREAM_PLAY		0		//ط
#define PUSH_PLAYBACK_STREAM_PAUSE		1		//طͣ

//״̬
#define		RET_BUFFER_IS_ALREADY_FULL		(-10)		//	Ѿˣûз뻺Ҫ·
#define		RET_BUFFER_IS_EMPTY				(-21)		//	
#define		RET_PAUSE_STATE					(-30)		//	ͣ״̬

//pushٶ
#define		PUSH_SLOW_SPEED		0
#define		PUSH_NORMAL_SPEED	1
#define		PUSH_FAST_SPEED		2

//pushStartPushṹ
#define 	MAX_ENCRYPT_KEY			16
#define		VIDEO_HEADER_SIZE		88
typedef struct
{
	int		m_iSize;							//ṹС
	char 	m_cFileHeader[VIDEO_HEADER_SIZE];	//Ƶͷ
	char	m_cEncryptKey[MAX_ENCRYPT_KEY + 4];	//ǰ豸Ƶ룬Ϊʾܣ
												//16ַұֽ֤
}START_PUSH_PARAM;

//Ϣ
#define		MIN_CONF_CMD					0
#define		CONF_CMD_VIDEOHEAD				MIN_CONF_CMD + 1
#define		CONF_CMD_AUDIOVIDEO				MIN_CONF_CMD + 2
#define		MAX_CONF_CMD					MIN_CONF_CMD + 2

//ļ״̬
#define  RET_UPGRADE_FINISH		0
#define  RET_UPGRADE_FAILED		-1
#define  RET_UPGRADE_ERROR		2

//öõ
#define SET_TOP		1
#define SET_DOWN	0

//豸
#define CMD_MIN_DEV_CONFIG	0
#define CMD_DEC_CFG_PROTOCOL						CMD_MIN_DEV_CONFIG + 0		//PTZЭ
#define CMD_DEC_CFG_ALARM_LINK_SWITCH				CMD_MIN_DEV_CONFIG + 1		//л
#define CMD_DEC_CFG_CREATE_VVO						CMD_MIN_DEV_CONFIG + 2		//ƴͨVVO
#define CMD_DEC_CFG_SPLIT_SCREEN					CMD_MIN_DEV_CONFIG + 3		//Զ廭ָʽ
#define CMD_DEC_CFG_CHANN_STATE						CMD_MIN_DEV_CONFIG + 4		//ȡͨ״̬
#define CMD_DEC_CFG_DISP_VONUM						CMD_MIN_DEV_CONFIG + 5		//豸ʾ
#define CMD_DEC_CFG_CHANN_NUM						CMD_MIN_DEV_CONFIG + 6		//ȡͨͨ
#define CMD_DEC_CFG_ALARM_SCHEDULE					CMD_MIN_DEV_CONFIG + 7		//ܷģ
#define CMD_DEC_CFG_ALARM_LINK						CMD_MIN_DEV_CONFIG + 8		//ܷ
#define CMD_DEC_CFG_ALARM_NOTIFY					CMD_MIN_DEV_CONFIG + 9		//;
#define CMD_DEC_CFG_ALARM_IN_OUT					CMD_MIN_DEV_CONFIG + 10		//ñ
#define CMD_DEC_CFG_SCHEDULE_ENABLE					CMD_MIN_DEV_CONFIG + 11		//ܷʹ
#define CMD_DEC_CFG_VGA_SIZE						CMD_MIN_DEV_CONFIG + 12		//ȡVGAС
#define CMD_DEC_CFG_SIP_VIDEO_CHANNEL				CMD_MIN_DEV_CONFIG + 13		//ȡSIPز
#define CMD_DEC_CFG_VIDEO_PARAM						CMD_MIN_DEV_CONFIG + 14		//ȡƵ
#define CMD_DEC_CFG_SYSTEM_TIME						CMD_MIN_DEV_CONFIG + 15		//ϵͳʱ
#define CMD_DEC_CFG_DEV_INFO						CMD_MIN_DEV_CONFIG + 16		//ȡ豸Ϣ	
#define CMD_DEC_CFG_TIMEZONE						CMD_MIN_DEV_CONFIG + 17		//ʱ
#define CMD_DEC_CFG_CHANNEL_REGINFO					CMD_MIN_DEV_CONFIG + 18		//ͨעϢ
#define CMD_DEC_CFG_SCREEN_DISPLAY					CMD_MIN_DEV_CONFIG + 19		//ʾ/
#define CMD_DEC_CFG_SCREEN_CHANGEAREA				CMD_MIN_DEV_CONFIG + 20		//ԶС/
#define CMD_DEC_CFG_GET_ABILITY_LEVEL				CMD_MIN_DEV_CONFIG + 21		//get function ability level
#define CMD_DEC_CFG_FLOAT_WINDOW					CMD_MIN_DEV_CONFIG + 22		//
#define CMD_DEC_CFG_SAVE_PLAN						CMD_MIN_DEV_CONFIG + 23		//Ԥ
#define CMD_DEC_CFG_APPLY_PLAN						CMD_MIN_DEV_CONFIG + 24		//ӦԤ
#define CMD_DEC_CFG_PLANALIAS						CMD_MIN_DEV_CONFIG + 25		//Ԥ
#define CMD_DEC_CFG_BASE_OFFSET						CMD_MIN_DEV_CONFIG + 26		//ʼ
#define CMD_DEC_CFG_LOGOPARAM						CMD_MIN_DEV_CONFIG + 27		//logo
#define CMD_DEC_CFG_DECOSD							CMD_MIN_DEV_CONFIG + 28		//OSDӲ
#define CMD_DEC_CFG_PICNUM							CMD_MIN_DEV_CONFIG + 29		//
#define CMD_DEC_CFG_WINDOW_SEQUENCE					CMD_MIN_DEV_CONFIG + 30		//ڴ
#define CMD_DEC_CFG_REGSERVER						CMD_MIN_DEV_CONFIG + 31		//
#define CMD_DEC_CFG_PUPARAM							CMD_MIN_DEV_CONFIG + 32		//
#define CMD_DEC_CFG_DZ_INFO							CMD_MIN_DEV_CONFIG + 33		//
#define CMD_DEC_CFG_SELECT_PIC						CMD_MIN_DEV_CONFIG + 34		//
#define CMD_DEC_CFG_CHANNEL_REGINFO_EX				CMD_MIN_DEV_CONFIG + 35		//
#define CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX			CMD_MIN_DEV_CONFIG + 36		//
#define CMD_DEC_CFG_DEVCOMMONNAME					CMD_MIN_DEV_CONFIG + 37		//ͨ
#define CMD_DEC_CFG_EXPORT_CONFIG					CMD_MIN_DEV_CONFIG + 38	    // export config
#define CMD_DEC_CFG_SHOW_OFFLINE_CHAN				CMD_MIN_DEV_CONFIG + 39	    // Ƿʾͨ
#define CMD_DEC_CFG_PLATFORM_LIST					CMD_MIN_DEV_CONFIG + 40		//ƽ̨б
#define CMD_DEC_CFG_COM_PARAM						CMD_MIN_DEV_CONFIG + 41	
#define CMD_DEC_CFG_SINGLEPIC						CMD_MIN_DEV_CONFIG + 42		//˫Ŵ/С
#define CMD_DEC_CFG_AUTOTEST_SYSTEMTYPE				CMD_MIN_DEV_CONFIG + 43
#define CMD_DEC_CFG_AUTOTEST_DEVICEPRODUCTER		CMD_MIN_DEV_CONFIG + 44
#define CMD_DEC_CFG_SCREEN_REGION					CMD_MIN_DEV_CONFIG + 45
#define CMD_DEC_CFG_SCREEN_BASICPARA				CMD_MIN_DEV_CONFIG + 46
#define CMD_DEC_CFG_SCREEN_OUTPUT_MODE				CMD_MIN_DEV_CONFIG + 47
#define CMD_DEC_CFG_PICLEVEL_RELATION				CMD_MIN_DEV_CONFIG + 48
#define CMD_DEC_CFG_SYNCLOOPCTRL					CMD_MIN_DEV_CONFIG + 49
#define CMD_DEC_CFG_SYNCLOOPTIME					CMD_MIN_DEV_CONFIG + 50
#define CMD_DEC_CFG_ENCODERPAPA						CMD_MIN_DEV_CONFIG + 51
#define CMD_DEC_CFG_HTTPPORT						CMD_MIN_DEV_CONFIG + 52
#define CMD_DEC_CFG_SHOWICON						CMD_MIN_DEV_CONFIG + 53
#define CMD_DEC_CFG_ALARM_EFFECT_LIGHT				CMD_MIN_DEV_CONFIG + 54
#define CMD_DEC_CFG_ALARM_EFFECT_REGION				CMD_MIN_DEV_CONFIG + 55
#define CMD_DEC_CFG_ALARM_EFFECT_TEXT				CMD_MIN_DEV_CONFIG + 56
#define CMD_DEC_CFG_PLANLOOPITEM					CMD_MIN_DEV_CONFIG + 57
#define CMD_DEC_CFG_PLANLOOP						CMD_MIN_DEV_CONFIG + 58
#define CMD_DEC_CFG_PLANLOOPITEMDEL					CMD_MIN_DEV_CONFIG + 59
#define CMD_DEC_CFG_LANPARAM_WORKMODE				CMD_MIN_DEV_CONFIG + 60
#define CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX_V2			CMD_MIN_DEV_CONFIG + 61
#define CMD_DEC_CFG_CHANNEL_MAX_WIN					CMD_MIN_DEV_CONFIG + 62	
#define CMD_DEC_CFG_CHANNEL_LAYOUTLIST				CMD_MIN_DEV_CONFIG + 63	
#define CMD_DEC_CFG_CHANNEL_RESOLUTIONLIST			CMD_MIN_DEV_CONFIG + 64	
#define CMD_DEC_CFG_GETSCREENCTLPROTOCOLS			CMD_MIN_DEV_CONFIG + 65	
#define CMD_DEC_CFG_SCREENCRL_PROTOCOL				CMD_MIN_DEV_CONFIG + 66	
#define CMD_DEC_CFG_SET_CHANNEL_VIDEO				CMD_MIN_DEV_CONFIG + 67	
#define CMD_DEC_CFG_CURVIDEO						CMD_MIN_DEV_CONFIG + 68	
#define CMD_DEC_CFG_VIDEO_PLAYMODE					CMD_MIN_DEV_CONFIG + 69	
#define CMD_DEC_CFG_GETPLANLOOPSTATUS				CMD_MIN_DEV_CONFIG + 70	
#define CMD_DEC_CFG_START_LOOP						CMD_MIN_DEV_CONFIG + 71	
#define CMD_DEC_CFG_STOP_LOOP					    CMD_MIN_DEV_CONFIG + 72	
#define CMD_DEC_CFG_ALL_CHANNEL_VIDEO				CMD_MIN_DEV_CONFIG + 73	
#define CMD_MAX_DEV_CONFIG							CMD_MIN_DEV_CONFIG + 74	


#define MAX_PROTOCOL_NUM				128		//DEC֧128Э
#define MAX_PROTOCOL_NAME_LEN32			32		//豸ֵ֧ЭƵ󳤶
typedef struct
{
	int		m_iCount;					//Э
	char 	m_cProtocol[MAX_PROTOCOL_NUM][MAX_PROTOCOL_NAME_LEN32];		
							//Эƣ֧128Э飬ÿЭ31ֽڣ
} TDECPROTOCOL_EX;

#define DEC_ALARM_TYPE_BASE			128
#define DEC_ALARMTYPE_VIDEOLOST		128 + 0
#define DEC_ALARMTYPE_NET_PORT		128 + 1
#define DEC_ALARMTYPE_MOVE			128 + 2
#define DEC_ALARMTYPE_LOCAL_PORT	128 + 7
#define DEC_ALARMTYPE_POWER         128 + 8
#define DEC_MAX_ALARM_TYPE			128 + 9

#define ALARM_LINK_SWITCH_ENBALE		1
#define ALARM_LINK_SWITCH_DISENBALE		0
//л
typedef struct tagAlarmLinkSwitch
{
	int  iBufSize;		//ṹС
	int  iAlarmType;	//	"0Ƶʧ1˿ڱ2ƶ⣻3Ƶڵ4ܷ5Ƶʧ6,ʪȱ
						//128֮ʹãģʽ=128 + iTypeһбʾֵ
						//128Ƶʧ
						//129˿ڱ
						//130ƶ⣻
						//131159Ԥ
						//160ض˿ڱ"					
	int  iPortNo;					//˿ں	Ϊض˿ڱʱֶЧ					
	int  iChannelNo;				//ͨ						
	int  iPos;						//						
	char cSerName[DEC_LEN_32];		//ǰ豸						
	char cSerIP[DEC_LEN_16];		//ǰ豸IPַ						
	char cSerProxy[DEC_LEN_16];		//ǰ豸IP						
	int  iSerChan;					//ǰ豸ͨ	serTypeΪ4ʱserChanΪͨserTypeΪ5ʱserChanΪͨ					
	int  iSerStreamNo;				//	0,1					
	int  iSerNetmode;				//ģʽ	1TCP2UDP3ಥ					
	int	 iUseddns;					//Ƿʹddns	0IP13ģʽ					
	int  iSerPort;					//˿ں						
	char cUserName[DEC_LEN_32];		//ǰ豸¼û						
	char cPassword[DEC_LEN_32];		//ǰ豸¼						
	int  iHoldTime;					//ͣʱ	10-999					
	char cEncrypt[DEC_LEN_32];		//ǰ豸Ƶ						
	int  iSerType;					//ǰ豸	0Tiandy1Onvif2push	3rtsp4ڲͨ5ͨ1000ʼǳҶԽ  1001LG 1002
	char cRtspUrl[DEC_LEN_256];
	int  iLinkSwitchEnable;
}AlarmLinkSwitch, *pAlarmLinkSwitch;

//ָʹֱȱʾ
typedef struct tagScreenPara
{
	int iBufSize;		//ṹС
	int iX;				//ʼ
	int	iY;				//ʼ
	int	iWidth;			//
	int	iHeight;		//
}ScreenPara, *pScreenPara;

//ƴͨVVO
typedef struct tagInputChannelParam
{
	int		   iMode;
	ScreenPara tSplitScreenPara;
}InputChannelParam;

typedef struct tagCreateVVOInfo
{
	int					iBufSize;									//ṹС
	int					iVVOChannelNo;								//ƴͨ
	int					iRows;										//ƴ
	int					iCols;										//ƴ
	int					iInputChannel[DEC_MAX_PHYSICAL_CHANNEL_NUM];	//󶨵ͨţû0x7fffffffʾ
	InputChannelParam	tInputChannelParam[DEC_MAX_PHYSICAL_CHANNEL_NUM];//ͨ
	int					iScreenType;
	ScreenPara          tEffectiveArea;
}CreateVVOInfo, *pCreateVVOInfo;


//Զ廭ָʽ
typedef struct tagSplitScreen
{
	int			iBufSize;										//ṹС
	int			iVVOChannelNo;									//ƴͨ
	int			iPicNum;										//16
	ScreenPara	tSplitScreenPara[DEC_MAX_PICTURE_NUM];			//
}SplitScreen, *pSplitScreen;

//ͨ״̬
#define CHANEEL_ON_LINE		1
#define CHANNEL_OFF_LINE	0

#define DECODE_CHANNEL		0
#define ENCODE_CHANNEL		1
typedef struct tagLocalChannelState
{
	int			iBufSize;				//ṹС
	int			iChannelNo;				//ͨ
	int			iState;					//״̬, 0-  1-  2-
	int			iType;					//ͨ, 0-ͨ 1-ͨ
}LocalChannelState, *pLocalChannelState;

#define DEC_MAX_DAYS	7
#define DEC_MAX_TIMESEGMENT		4
//Schedle time
typedef struct tagDEC_SCHEDTIME
{
	int      iStartHour;
	int      iStartMin;
	int      iStopHour;
	int      iStopMin;
	int      iEnable;
}DEC_SCHEDTIME, *PDEC_SCHEDTIME;

//ʱ
typedef struct tagAlarmScheduleParam
{
	int				iBuffSize;
	int				iChannelNo;	//ʶܷͨ
	int				iAlarmType;	//128Ƶʧ129˿ڱ130ƶ⣻131134Ԥ135ض˿ڱ
	int				iWeekday;	//յ0-6
	int				iParam1;	//iType=4ʱʾID
	int				iParam2;	//iType= 4ʱʾ¼ͣ0 1˫ 2ܽ 3ǻ 4ͣ 5
								//6Աܶ 7 8 9ʶ 10Ƶ
								//11:ܸ 12ͳ 13Ⱥۼ 14ڼ⣩
	DEC_SCHEDTIME	timeSeg[DEC_MAX_DAYS][DEC_MAX_TIMESEGMENT];		//	ʱ
	void*			pvReserved;									
}AlarmScheduleParam, *PAlarmScheduleParam;

typedef struct tagAlarmLink
{
	int	iBuffSize;
	int iChannelNo;			//ȡֵΧ豸Ͷ
	int	iAlarmType;			//128Ƶʧ129˿ڱ130ƶ⣻131134Ԥ135ض˿ڱ136Դ
	int	iAlarmTypeParam;	//ȡֵiAlarmTypeiAlarmTypeΪܷiAlarmTypeParamʾiRuleID
	char cReserved[DEC_LEN_32];
	int	iLinkType;			//,0ʾ1Ļʾ2˿ڣ3¼4PTZ5ץģ
	int	iLinkParam1;	//,ȡֵiLinkTypeiLinkType=0,1ʱiParam1ʾʹiEnable0ʹܣ1ʹܡ
	//iLinkType=2,3,5,6ʱiParam1ʾλʹiEnableByBitsλλÿһλʾһƵͨ/˿ڵʹܡ
	//iLinkType=4ʱiParam1ʾͨiLinkChannel,ȡֵΧ豸Ͷ
	//iParam2ʾiLinkType0ͨPTZ1Ԥλ2켣3·iParam3ʾPTZiNo
	//iParam2ͷֱʾԤλţ켣ź·
	int	iLinkParam2;	//
	int	iLinkParam3;	//
}AlarmLink, *PAlarmLink;

#define DEC_MAX_PORT_NUM        64
#define MAX_ALARM_IN_OUT_TYPE	4

//ñǸߵƽǵ͵ƽ
#define DEC_ALARM_IN_LHP	0
//ñǸߵƽǵ͵ƽ
#define DEC_ALARM_OUT_LHP	1
//ñ˿ʹ
#define DEC_ALARM_IN_PORT	2
//ñ˿ʹ
#define DEC_ALARM_OUT_PORT	3

typedef struct tagAlarmInAndOut
{
	int	iBuffSize;
	int	iType;		//0ߵ͵ƽã1ߵ͵ƽã2˿ʹܣ3˿ʹ
	int	iPortNo;	//˿ں
	int	iPara1;		//iTypeȡֵй
	int	iPara2;		//
}AlarmInAndOut, *PAlarmInAndOut;

typedef struct tagAlarmNotify
{
	int	iBuffSize;
	int	iAlarmType;	//128Ƶʧ129˿ڱ130ƶ⣻131134Ԥ135ض˿ڱ
	int	iChannelNo;	//ͨ,iType = 160ʾض˿ں
	int	iState;		//10
}AlarmNotify, *pAlarmNotify;

typedef struct tagScheduleEnable
{
	int	iBuffSize;
	int iChannelNo;
	int	iAlarmType;		//128Ƶʧ129˿ڱ130ƶ⣻131134Ԥ135ض˿ڱ136 Դ澯
	int	iEnable;		//Ƿʹ,0ʹ 1ʹ
	int	iParam1;		//1
	int	iParam2;		//2
	int	iParam3;		//3
}ScheduleEnable, *pScheduleEnable;

typedef struct tagVGASize
{
	int	iBuffSize;
	int iChannelNo;
	int iVGASize;
}VGASize, *pVGASize;

//Զ
#define CMD_AUTOTEST_MIN                    0
#define	CMD_AUTOTEST_SETMACADDR				(CMD_AUTOTEST_MIN+1)	  //MACַ
#define	CMD_AUTOTEST_LAN					(CMD_AUTOTEST_MIN+2)	  //
#define	CMD_AUTOTEST_USB					(CMD_AUTOTEST_MIN+10)     //USBڣ
#define	CMD_AUTOTEST_ALARMIN				(CMD_AUTOTEST_MIN+12)	  //Ա˿ڣ
#define	CMD_AUTOTEST_ALARMOUT				(CMD_AUTOTEST_MIN+13)	  //Ա˿ڣ
#define	CMD_AUTOTEST_RTC			   		(CMD_AUTOTEST_MIN+15)	  //ʱоƬ
#define	CMD_AUTOTEST_BACKUPSYSTEM			(CMD_AUTOTEST_MIN+20)	  //ϵͳ
#define CMD_AUTOTEST_VERIFYTIME				(CMD_AUTOTEST_MIN+26)	  //ʱУ
#define AUTOTEST_SWITCHLAN					(CMD_AUTOTEST_MIN+38)     //лUIԣ
#define CMD_AUTOTEST_FPGASTATUS             (CMD_AUTOTEST_MIN+39)	  //FPGAĹ״̬
#define CMD_AUTOTEST_DOUBLEPOWER_ALARM      (CMD_AUTOTEST_MIN+40)	  //˫Դ
#define CMD_AUTOTEST_UPDATEVOCHIP	        (CMD_AUTOTEST_MIN+41)	  //ƵоƬ
#define CMD_AUTOTEST_POWERDOWNDETECTIVE     (CMD_AUTOTEST_MIN+42)	  //ػź
#define CMD_AUTOTEST_CLUSTER				(CMD_AUTOTEST_MIN+99)	  //S5ȺɼȺ
#define	CMD_AUTOTEST_END					(CMD_AUTOTEST_MIN+100)	  //Խ
#define	CMD_AUTOTEST_MAX					(CMD_AUTOTEST_MIN+101)
//
#define PRODUC_TIANDY                        0
#define PRODUC_OEM                           1
//UI
#define LANGUAGE_ENGLISH                     0
#define LANGUAGE_CHINESE                     1

typedef struct tagSystemTime
{
	int iBuffsize;
	int iYear;
	int iMonth;
	int iDay;
	int iHour;
	int iMin;
	int iSec;
}SystemTime, *pSystemTime;

typedef struct  
{
	int iSize;
	int iChanNum;
	int iAlarmInNum;
	int iAlarmOutNum;
	int iComNum;
	int iSplitChanNum;
	int iEncChanNum;
	int iUsbInterfaceNum;
	int iNetCardNum;
	int	iLocalInChnNum;
}tDevInfo, *ptDevInfo;

#define TOTAL_CHANNEL_NUM	24
typedef struct tagChannelRegInfo
{
	int		iBuffsize;
	int		m_iRegChannelNum[TOTAL_CHANNEL_NUM];
	char	m_cRegChannelPUID[TOTAL_CHANNEL_NUM][DEC_LEN_32+1];
}ChannelRegInfo, *pChannelRegInfo;

typedef struct tagChannelRegInfoEx
{
	int		iBuffsize;
	char	cRegChannelPUID[DEC_LEN_32+1];
}ChannelRegInfoEx, *pChannelRegInfoEx;


#define DEC_MAIN_FUNC_DECODER		0x6
#define DEC_SUB_FUNC_MPIC			0
#define DEC_SUB_FUNC_ALARMIN		1
#define DEC_SUB_FUNC_ALARMOUT		2
#define DEC_SUB_FUNC_VVO_SPLIT		3
#define DEC_SUB_FUNC_DEFINEPIC		4
#define DEC_SUB_FUNC_PICHIDE		5
#define DEC_SUB_FUNC_COM			6
#define DEC_SUB_FUNC_TALK			7
#define DEC_SUB_FUNC_CLUSTER		8
#define DEC_SUB_FUNC_EASYX_WINDOW	9
#define DEC_SUB_FUNC_LEVELRELATION	10
#define DEC_SUB_FUNC_ENCODECFG		11
#define DEC_SUB_FUNC_MULTIAUDIO		12
#define DEC_SUB_FUNC_LOCALINPUT		13
#define DEC_SUB_FUNC_PREVIEW		14
#define DEC_SUB_FUNC_SCREENCTRL		15
#define DEC_SUB_FUNC_UDISKFILEPLAY	16
#define DEC_SUB_FUNC_PLANLOOP		17
#define DEC_SUB_FUNC_STRIPEDSCREEN	18
#define DEC_SUB_FUNC_4KMODE			19
#define DEC_SUB_FUNC_POWERALARM		20
#define DEC_SUB_FUNC_28181PARAM		21
#define DEC_SUB_FUNC_REBOOTDOCKING	22 //Խӳ
#define DEC_SUB_FUNC_REMOTESWICHNET	23 //Զ̿
#define DEC_SUB_FUNC_ENCODECHN_PROOFADJUST	24 //ͨƫɫƫ
#define DEC_SUB_FUNC_LOCALINPUTCHN_PROOFADJUST 25 //ͨƫɫƫ
#define	DEC_SUB_FUNC_LED_SMALLPITCH 26 //Ƿ֧LEDС	01֧֣ 2֧
#define DEC_MAX_SUB_FUNC_TYPE		27
typedef struct _tagDecAbilityLevel
{
	int		iSize;
	int		iMainFuncType;			//main function type
	int		iSubFuncType;			//sub function type
	char	cParam[DEC_LEN_256];	//Capability Description
} DecAbilityLevel, *pDecAbilityLevel;

#define DEC_INVALID_CHANNEL 0x7FFFFFFF

#define DEC_NO_CHANNEL_PARAM -1  //ͨ޹
#define DEC_NO_PIC_PARAM     -1	//޹

/***************************************************************

Prameter(in) 	_lID¼ID
				_uiMsgϢ
				_iChannelͨ
				_iPosں
				_pvParam
				_iParamSizeСֽڣ
				_pvUserDataû DEC_ClientLogonEx
***************************************************************/
typedef int (*MainNotify)(unsigned long _lID, unsigned int _uiMsg, unsigned int _iChannel, int _iPos, void* _pvParam, int _iParamSize, void* _pvUserData);

typedef int (*ParamChangeNotify)(unsigned long _lID, unsigned int _uiMsg, unsigned int _iChannel, int _iPos, void* _pParam, int _iParamSize, void* _lpUserData);
#define  DEC_PARACHANGE_DNSABSTRACT					1
#define  DEC_PARACHANGE_TVINFO						2
#define  DEC_PARACHANGE_RS485TYPE					3
#define  DEC_PARACHANGE_ALARMOUT					4
#define  DEC_PARACHANGE_CHANNELINFO					5
#define  DEC_PARACHANGE_SETLOOPITEM					6
#define  DEC_PARACHANGE_DELLOOPITEM					7
#define  DEC_PARACHANGE_STARTLOOP					8
#define  DEC_PARACHANGE_STOPTLOOP					9
#define  DEC_PARACHANGE_GETPTZPROTOCOLS				10
#define  DEC_PARACHANGE_PLATFORMRUN					11
#define  DEC_PARACHANGE_VGA							12
#define  DEC_PARACHANGE_MANAGERINFO					13
#define  DEC_PARACHANGE_COMMONINFO					14
#define  DEC_PARACHANGE_COMMONINFO_CHANNEL			15
#define  DEC_PARACHANGE_DZCOMMON					16
#define  DEC_PARACHANGE_SIP_VIDEOCHANNEL			17
#define  DEC_PARACHANGE_VIDEOPARAM					18
#define  DEC_PARACHANGE_VOLUME						19
#define  DEC_PARACHANGE_ALARM_LINKSWITCH			20
#define  DEC_PARACHANGE_CREATEFREEVO				21
#define  DEC_PARACHANGE_ALARM_SCHEDULE				22
#define  DEC_PARACHANGE_ALARMLINK					23
#define  DEC_PARACHANGE_ALM_IN_LHP					24
#define  DEC_PARACHANGE_ALM_OUT_LHP					25
#define  DEC_PARACHANGE_ALARM_INPORT				26
#define  DEC_PARACHANGE_ALARM_OUTPORT				27
#define  DEC_PARACHANGE_SCHEDULE_ENABLE				28
#define  DEC_PARACHANGE_TIMEZONE					29
#define  DEC_PARACHANGE_DISPLAY						30
#define  DEC_PARACHANGE_CHANGEAREA					31
#define  DEC_PARACHANGE_CREATEVVO					32
#define  DEC_PARACHANGE_SELECT_PIC					33
#define  DEC_PARACHANGE_PREFERENCE					34
#define  DEC_PARACHANGE_RESEVELASTFRAME				35
#define  DEC_PARACHANGE_LOGOPARAM					36
#define  DEC_PARACHANGE_DEVICEABSTRACT				37
#define  DEC_PARACHANGE_CLUSTER_ALIAS				38
#define  DEC_PARACHANGE_CLUSTER_CLUSTERINFO			39
#define  DEC_PARACHANGE_CLUSTER_DEVINFO				40
#define  DEC_PARACHANGE_CLUSTER_CONTRAL_CARD_INFO 	41
#define  DEC_PARACHANGE_CLUSTER_WORK_CARD_INFO	  	42
#define  DEC_PARACHANGE_MERAGE_CLUSTER				43
#define  DEC_PARACHANGE_DEMERAGE_CLUSTER			44
#define  DEC_PARACHANGE_FLOAT_WINDOW 				45
#define  DEC_PARACHANGE_PLAN 						46
#define  DEC_PARACHANGE_PLAN_ALIAS 					47
#define  DEC_PARACHANGE_OSD 						48
#define  DEC_PARACHANGE_CLUSTER_IP					49
#define  DEC_PARACHANGE_APPLY_PLAN					50
#define  DEC_PARACHANGE_DEVCOMMONNAME				51
#define  DEC_PARACHANGE_DETECT_CHANN_STATE			52
#define  DEC_PARACHANGE_SHOWOFFLINECHN				53
#define  DEC_PARACHANGE_DEVICEMACADDR				54
#define  DEC_PARACHANGE_PLATFORM_LIST				55
#define  DEC_PARACHANGE_CTRL_MAC					56
#define	 DEC_PARACHANGE_SINGLE_PIC					57
#define  DEC_PARACHANGE_AUTOTEST_SYSTEMTYPE			58
#define  DEC_PARACHANGE_AUTOTEST_DEVICEPRODUCTER	59
#define  DEC_PARACHANGE_SCREEN_REGION				60
#define  DEC_PARACHANGE_SCREEN_BASICPARA			61
#define  DEC_PARACHANGE_SCREEN_OUTPUT_MODE			62
#define  DEC_PARACHANGE_PICLEVEL_RELATION			63
#define  DEC_PARACHANGE_SYNCLOOPCTRL				64
#define  DEC_PARACHANGE_SYNCLOOPTIME				65
#define  DEC_PARACHANGE_ENCODERPAPA					66
#define  DEC_PARACHANGE_HTTPPORT					67
#define  DEC_PARACHANGE_SHOWICON					68
#define	 DEC_PARACHANGE_ALARM_EFFECT_LIGHT			69
#define  DEC_PARACHANGE_ALARM_EFFECT_REGION			70
#define  DEC_PARACHANGE_ALARM_EFFECT_TEXT			71
#define  DEC_PARACHANGE_HD_DISPLAY					72
#define  DEC_PARACHANGE_PLAN_LOOP_ITEM              73
#define  DEC_PARACHANGE_PLAN_LOOP		            74
#define  DEC_PARACHANGE_PLAN_LOOP_ITEM_DEL          75 
#define  DEC_PARACHANGE_LANPARAM_WORKMODE           76
#define  DEC_PARACHANGE_SIP_VIDEO_CHANNEL_EX_V2	    77
#define  DEC_PARACHANGE_CHAN_MAX_WIN			    78
#define  DEC_PARACHANGE_CHAN_LAYOUTLIST			    79
#define  DEC_PARACHANGE_CHAN_RESOLUTIONLIST		    80
#define  DEC_PARACHANGE_GETSCREENCTLPROTOCOLS	    81
#define  DEC_PARACHANGE_SCREENCRLPROTOCOL		    82
#define  DEC_PARACHANGE_SET_CHANNEL_VIDEO		    83
#define  DEC_PARACHANGE_CURVIDEO				    84
#define  DEC_PARACHANGE_VIDEO_PLAYMODE			    85
#define  DEC_PARACHANGE_PLAN_LOOP_ITEM_LIST         86
#define  DEC_PARACHANGE_STARTPLANLOOP				87
#define  DEC_PARACHANGE_STOPPLANLOOP				88
#define  DEC_PARACHANGE_TELNET						89

typedef struct _tagDecNotifyFun
{
	int iSize;
	ParamChangeNotify pParamChangeNotify;
	MainNotify pMainNotify;
}DecNotifyFun, *pDecNotifyFun;

#define MAX_PAGE_LOG_SIZE	20
typedef struct	_tagDecLogQuery			
{
	int			iChannelNo;		//	ͨ
	int			iLogType;		//	־
	int			iLanguage;		//	
	NVS_FILE_TIME	struStartTime;		//	ʼʱ
	NVS_FILE_TIME	struStopTime;		//	ʱ
	int			iPageSize;		//	ҳС
	int			iPageNo;		//	ҳ
}DecLogQuery, *PDecLogQuery;


#define MAX_LOG_LEN   130
typedef struct  _tagDecLogData
{
	int				iChannel;
	int				iLogType;
	NVS_FILE_TIME	struStartTime; 	/* File start time */
	/*NVS_FILE_TIME	struStoptime; 	/ * File end time * /*/
	char			cLogContent[MAX_LOG_LEN];					
}DecLogData,*PDecLogData;

#define MIN_CLUSTER_OP						 0
#define CLUSTER_MERAGE						 MIN_CLUSTER_OP
#define CLUSTER_DEMERAGE					(MIN_CLUSTER_OP+1)
#define CLUSTER_ALIAS						(MIN_CLUSTER_OP+2)
#define CLUSTER_CLUSTERINFO					(MIN_CLUSTER_OP+3)
#define CLUSTER_CONTROL_CARD_VERSIONINFO	(MIN_CLUSTER_OP+4)
#define CLUSTER_WORK_CARD_VERSIONINFO		(MIN_CLUSTER_OP+5)
#define CLUSTER_CONTROL_CARD_STATE			(MIN_CLUSTER_OP+6)
#define CLUSTER_WORK_CARD_STATE				(MIN_CLUSTER_OP+7)
#define CLUSTER_IP							(MIN_CLUSTER_OP+8)
#define CLUSTER_DEVICE_INFO					(MIN_CLUSTER_OP+9)
#define CLUSTER_SEARCH						(MIN_CLUSTER_OP+10)
#define CLUSTER_DEVICE_STATE				(MIN_CLUSTER_OP+11)
#define CLUSTER_CTRL_MAC					(MIN_CLUSTER_OP+12)
#define MAX_CLUSTER_OP						(MIN_CLUSTER_OP+13)

typedef struct tagClusterMerage
{
	int		iSize;
	char	cIP[LEN_64];
	int     iPort;
	char    cUserName[LEN_32];
	char    cPassword [LEN_32];
	char    cClusterId [LEN_64];
}ClusterMerage, *pClusterMerage;

typedef struct tagClusterAlias
{
	int		iSize;
	char	cAlias[LEN_64];
}ClusterAlias, *pClusterAlias;

typedef struct tagClusterInfo
{
	int		iSize;
	char	cClusterId[LEN_64];
	int		iDevNum;
}ClusterInfo, *pClusterInfo;

#define MAX_CLUSTER_DEVICE_COUNT 4
#define MAX_CONTROL_CARD_COUNT	 2
#define MAX_CONTROL_NET_COUNT	 2
#define MAX_WORK_CARD_COUNT      16
#define MAX_NET_CARD_COUNT		8

#define CARD_TYPE_CONTROL	1
#define CARD_TYPE_DECODE	2
#define CARD_TYPE_ENCODE	3

typedef struct tagClusterControlCardInfo
{
	int    iSize;
	int    iDevId;	
	int	   iCardId;
	char   cMasterVersion[LEN_64];
	char   cProxyVersion[LEN_64];
	char   cStreamVersion[LEN_64];    
	int    iProductModel;
	char   cSpecialVersion[LEN_64];    
	char   cDeviceModel[LEN_64];
	char   cOnvifVersion[LEN_64];  
	char   cMcuVersion[LEN_64];  
}ClusterControlCardInfo, *pClusterControlCardInfo;

typedef struct tagClusterWorkCardInfo
{
	int    iSize;
	int    iDevId;	
	int	   iCardId;
	int    iCardType;
	char   cVersion[LEN_64];
	int    iEncChnNo;	//ͨͨţ뿨ʹ
	int    iProductModel;
	char   cFpgaInVersion[LEN_64];    
	char   cFpgaOutVersion[LEN_64];
}ClusterWorkCardInfo, *pClusterWorkCardInfo;

typedef struct tagClusterDeviceInfo
{
	int    iSize;
	int    iDevId;
	int    iCtrlCardNum;
	int    iSlotdNum;
	int    iAlarmInNum;
	int    iAlarmOutNum;
	int    iComNum;    
}ClusterDeviceInfo, *pClusterDeviceInfo;

typedef struct tagClusterCardState
{
	int    iSize;	
	int    iDevId;
	int    iCardId;
	int    iState;
	int    iType;
	int    iMaxCaptility;
	int    iCurrentCaptility;    
	int    iProgress;
}ClusterCardState, *pClusterCardState;


#define SEEK_DEVICE_IPC  1
#define SEEK_DEVICE_NVD  2

#define SEEK_TYPE_IP	0
#define SEEK_TYPE_DNS	1
#define SEEK_TYPE_DMS	2
typedef struct tagClusterSearchParam
{
	int iSize;
	int iSeekDevice; // SEEK_DEVICE_IPCSEEK_DEVICE_NVD
	int iSeekType; //SEEK_TYPE_IPSEEK_TYPE_DNSSEEK_TYPE_DMS
}ClusterSearchParam, *PClusterSearchParam;

typedef struct tagClusterSearchResult
{
	int iSize;
	char cMac[LEN_64];
	char cIP[LEN_64];
	char cMask[LEN_64]; 
	char cGateWay[LEN_64]; 
	char cDNS[LEN_64];
	int iChannelNum;
	int iServerPort;
	int iClientPort;
	int iDeviceType;
	int iHttpPort;
	int iProductModel;
	char cFactoryID[LEN_64];
	char cKernelVersion[LEN_64];
	char cOcxVersion[LEN_64];
	char cClusterId[LEN_64];
	char cClusterAlias[LEN_64];
	int iDevNum;
	int iSeekType;//SEEK_TYPE_IPSEEK_TYPE_DNSSEEK_TYPE_DMS
}ClusterSearchResult, *PClusterSearchResult;

#define CHANGEIP_TYPE_SINGLE 0 
#define CHANGEIP_TYPE_ALL	 1 
typedef struct tagClusterChangeIP
{
	int		iSize;
	int		iDevId;
	int		iCardId;
	char	cIP[LEN_16];
	char	cSubMask[LEN_16];
	char	cGateway[LEN_16];
	char	cDns[LEN_16];    
	int		iType; // CHANGEIP_TYPE_SINGLE ,CHANGEIP_TYPE_ALL
	int		iIndex;
}ClusterIP, *PClusterChangeIP;


typedef struct tagFloatWindow
{
	int    iSize;
	int    iEnable;
	ScreenPara tArea;
}FloatWindow, *pFloatWindow;

#define MAX_PLAN_COUNT 16
typedef struct tagDecPlan
{
	int    iSize;
	int	   iPlanId;
	char   cSaveTime[LEN_64];
}DecPlan, *pDecPlan;

typedef struct tagApplyPlan
{
	int    iSize;
	int	   iPlanId;
}ApplyPlan, *pApplyPlan;

typedef struct tagPlanAlias
{
	int    iSize;
	int    iPlanId;
	char   cAlias[LEN_64];
}PlanAlias, *pPlanAlias;

#define WINDOW_SEQUENCE_TOP		 1
#define WINDOW_SEQUENCE_BOTTOM   0

typedef struct tagWindowSequence
{
	int iSize;
	int iSequence; // WINDOW_SEQUENCE_TOP WINDOW_SEQUENCE_BOTTOM
}WindowSequence, *PWindowSequence;

typedef struct tagChannelLogoParam
{
	int    iSize;
	TLOGOPARAM tLogoParam;
}ChannelLogoParam, *pChannelLogoParam;

#define ALIGN_ABOUT_BWLOW_MIDDLE  0		//¾
#define ALIGN_ABOUT				  1		//϶
#define ALIGN_BWLOW				  2		//¶

#define ALIGN_LEFT_RIGHT_MIDDLE	  0		//Ҷ
#define ALIGN_LEFT				  1		//
#define ALIGN_RIGHT				  2		//Ҷ

#define SHOW_STATIC               0		//̬ʾ
#define SHOW_DYNAMIC_LEFT_RIGHT   1		//ƶ̬ʾ
#define SHOW_DYNAMIC_ABOUT_BWLOW  2		//ƶ̬ʾ
#define SHOW_STATIC_LINE_DISPLAY  3     //̬ʾ

typedef struct tagDecOsd
{
	int   iSize;
	char  cOsd[LEN_256];
	int   iColor;
	int   iBackColor;
	int   iDiaphaneity;//0-100
	int   iFontSize; // 1-5
	ScreenPara tArea;
	int   iAboutBelowAlign;//ALIGN_ABOUT_BWLOW_MIDDLEALIGN_ABOUTALIGN_BWLOW
	int   iLeftRightAlign;//ALIGN_LEFT_RIGHT_MIDDLEALIGN_LEFTALIGN_RIGHT
	int	  iDynamic;//SHOW_STATICSHOW_DYNAMIC_LEFT_RIGHTSHOW_DYNAMIC_ABOUT_BWLOWSHOW_STATIC_LINE_DISPLAY
	int	  iEnbale;
	int   iSwitchTime;//ʾлʱ
}DecOsd, *pDecOsd;

typedef struct tagBaseOffset
{
	int   iSize;
	int   iSplitScreen;
	int   iFloatWindow;
}BaseOffset, *pBaseOffset;

#define MAX_SERVER_ITEM_COUNT	8192
#define DEFAULT_SPLIT_SCREEN_OFFSET		10000
#define DEFAULT_OPEN_WINDOW_OFFSET		10000

typedef struct tagServerCommonInfo
{
	char cServerIp[DEC_LEN_32];
	int	 iServerPort;
	int	 iServerChannelNo;
	int	 iServerStreamNo;
	int  iServerNetmode;	//0:TCP, 1:UDP, 2:MUT
	int  iHoldTime;
	char cServerUserName[DEC_LEN_64];
	char cServerPassword[DEC_LEN_64];
	char cServerPtzProtocol[DEC_LEN_32];
	int  iServerPtzAddress;
	int  iSaveCfg;         //ñ־0棬 1
} ServerCommonInfo, *pServerCommonInfo;

#define DEC_CON_SER_MODE_IP			0
#define DEC_CON_SER_MODE_DDNS		1
#define DEC_CON_SER_MODE_DSM		2
typedef struct tagNormalServer
{
	int					iSize;		//input para,the size of struct
	ServerCommonInfo	tCommonInfo;
	int					iConnectMode;	//0:ip, 1:DDNS, 3:DSM
	char				cServerName[DEC_LEN_128];
	char				cServerProxy[DEC_LEN_32];
	char				cVideoDecryptPassword[DEC_LEN_32];
} NormalServer, *pNormalServer; 

typedef struct tagOnvifServer
{
	int					iSize;		//input para,the size of struct
	ServerCommonInfo	tCommonInfo;
} OnvifServer,*pOnvifServer;

typedef struct tagRtspServer
{
	int					iSize;		//input para,the size of struct
	ServerCommonInfo	tCommonInfo;
	char				cRtspUrl[DEC_LEN_512];
	char				cMultIP[DEC_LEN_32];
	int					iMultPort;
} RtspServer, *pRtspServer;

typedef struct tagEncodeChannel
{
	int					iSize;		//input para,the size of struct
	ServerCommonInfo	tCommonInfo;
} EncodeChannel, *pEncodeChannel;

typedef struct tagLocalInputChannel 
{
	int					iSize;
	ServerCommonInfo	tCommonInfo;
} LocalChannel, *pLocalInputChannel;

typedef union tagServerItem
{
	int				iSize;
	NormalServer	tNormal;
	OnvifServer		tOnvif;
	RtspServer		tRtsp;
	EncodeChannel	tEncode;
	LocalChannel    tLocal;
} ServerItem, *pServerItem;

typedef struct tagDecRegServer
{
	int iSize;
	char cIP[LEN_64];
	int iPort;
	int iEnable;
}DecRegServer, *PDecRegServer;

typedef struct tagDecPuParam
{
	int iSize;
	char cID[LEN_64];
	char cUsername[LEN_64];
}DecPuParam, *PDecPuParam;

typedef struct tagDecDzInfo
{
	int iSize;
	DZ_INFO_PARAM tInfo;
}DecDzInfo, *PDecDzInfo;

typedef struct tagDecSelectPic
{
	int iSize;
	int iPicNo;
}DecSelectPic, *PDecSelectPic;

typedef struct tagPushStreamResponse
{
	int iSize;
	long lPushId;
	int result;
}PushStreamResponse, *PPushStreamResponse;

#define MAX_DEC_CHANNEL_TYPE	4 //0-Ƶͨ 1-ͨ 2-ͨ 3-ͨ
typedef struct tagDevCommonName
{
	int  iSize;
	int  iChannelType;
	char cChannelName[DEC_LEN_64];
} DevCommonName, *pDevCommonName;


typedef struct tagChannelPicNum
{
	int  iSize;
	int  iPicNum;
	int	 iMode; // iPicNum == 20  1:20A 2: 20B
} ChannelPicNum, *pChannelPicNum;

typedef struct tagShowOfflineChan
{
	int  iSize;
	int	 iEnable; //1----ʾ  0:----ʾ
} ShowOfflineChan, *pShowOfflineChan;

typedef struct tagComParam
{
	int				iSize;
	int				iCom;
	unsigned char	ucType;			    //485ЭID0͸ͨ1:Pelco-P...
	unsigned char	ucAddress;			//485ַȡֵΧ0-255
	int				iBaudrate;		    //485240048009600
	unsigned char	ucDatabit;   		//485λĬΪ8
	unsigned char	ucStopbit;			//485ֹͣλĬΪ1
	unsigned char	ucCheckbit; 		//485Уλֿѡ0У飻1У飻2żУ飻
	unsigned char	ucFlowcontrol;		//485أĬΪأЧ
	int				iComType;			//0RS4851RS232̶ӣ2RS232
} ComParam, *PComParam;

typedef struct tagStopViewPara
{
	int        iSize;
	int        iChannel;
	int        iPos;
	int        iSaveLastFrame;	//Ƿһ֡0-(Ĭֵ)1-
	int        iSaveCfg;		//Ƿ񱣴ã0-棻1=棻ֶĬϱ
}StopViewPara, *pStopViewPara;

//CMD
#define DEC_COMMAND_MIN							0
#define DEC_COMMAND_PTZ_CONTROL			(DEC_COMMAND_MIN + 1)		//豸Э
#define DEC_COMMAND_PROOF_ADJUST		(DEC_COMMAND_MIN + 2)		//У뿨ƫƫɫ
#define DEC_COMMAND_LOGWRITE			(DEC_COMMAND_MIN + 3)		//cgi report log
#define DEC_COMMAND_USERNUM				(DEC_COMMAND_MIN + 4)		//ȡûĿ
#define DEC_COMMAND_USERINFO			(DEC_COMMAND_MIN + 5)		//ȡûϢ
#define DEC_COMMAND_GETUSERNUM			(DEC_COMMAND_MIN + 6)		//ȡû
#define DEC_COMMAND_GETUSERINFO			(DEC_COMMAND_MIN + 7)		//ȡû
#define DEC_COMMAND_GETLASTERROR		(DEC_COMMAND_MIN + 8)		//ȡ豸Ϣ
#define DEC_COMMAND_PICSNAP				(DEC_COMMAND_MIN + 9)		//·ץ
#define DEC_COMMAND_GETPICFILENAME		(DEC_COMMAND_MIN + 10)		//ȡץͼƬļ
#define DEC_COMMAND_SCREENCTLSET		(DEC_COMMAND_MIN + 11)      //ؿ·
#define DEC_COMMAND_REBOOTTRADE			(DEC_COMMAND_MIN + 12)      //
#define DEC_COMMAND_GETUDISK_VIDEOLISTS	(DEC_COMMAND_MIN + 13)      //ȡUƵ
#define DEC_COMMAND_VIDEO_PLAYSET		(DEC_COMMAND_MIN + 14)      //·ͨĲźֹͣ
#define DEC_COMMAND_DEL_PICSNAP			(DEC_COMMAND_MIN + 15)		//ɾץ
#define DEC_COMMAND_SOUNDCTRL_RESULT	(DEC_COMMAND_MIN + 16)		//ȡ״̬
#define DEC_COMMAND_TALKSERVER_RESULT	(DEC_COMMAND_MIN + 17)		//ȡԽ״̬
#define DEC_COMMAND_MAX					(DEC_COMMAND_MIN + 18)

typedef struct tagPtzControlPara
{
	int  iSize;
	int	 iActionType;	//ϡ¡ҡ䱶Ԥλ
	int  iControlType;	//0̨ͨƣ1̨e-PTZ.ȱʡΪ0
	int  iParam1;		//ĺҲһˮƽٶȻԤλš
	int  iParam2;		//ֱٶȡ
} PtzControlPara, *pPtzControlPara;


#define		PROOFADJUST_OPERTYPE_MANU		1		//1-manu 2-auto 
#define		PROOFADJUST_OPERTYPE_AUTO		2		
#define		PROOFADJUST_OUT_DEV_HDMI		1		//out dev 1-HDMI 2-VGA
#define		PROOFADJUST_OUT_DEV_VGA		    2		
#define    	PROOFADJUST_TYPE_RESO			1       //Type1-Video Resolution  2-Video Color
#define    	PROOFADJUST_TYPE_COLOR			2
#define    	PROOFADJUST_CHANNELTYPE_ENCODE     0       //Channel Type0-Encode  1-LocalInput
#define    	PROOFADJUST_CHANNELTYPE_LOCALINPUT 1
typedef struct tagProofAdjust
{
	int  iSize;
	int	 iOperateMethod;	//1-ֶ 2-Զ
	int  iVoId;				//1-HDMI 2-VGA
	int  iType;				//1-Ƶֱ  2-Ƶɫ
	int  iChannelType;      //ͨ޸ֶΣͨΪͨ,0-ͨ1-ͨ
} ProofAdjust, *pProofAdjust;

typedef struct tagAutoTestResult
{
	int iSize;
	int iItem;
	int iTestParam;
	int iResult;
	char cTestParam[LEN_128];
}AutoTestResult, *PAutoTestResult;


typedef struct tagUserInfo
{
	int  iSize;
	int  iUserId;
	char cUserName[LEN_16];
	char cPassword[LEN_16];
}UserInfo, *PUserInfo;

typedef struct tagUserNum
{
	int iSize;
	int iUserNum;
}UserNum, *PUserNum;

#define LOG_WRITE_TYPE_CHANGE_PASSWD_SUCCESS	4001
#define LOG_WRITE_TYPE_CHANGE_PASSWD_FAILED		4002
#define LOG_WRITE_TYPE_LOGON_SUCCESS			4003
#define LOG_WRITE_TYPE_LOGON_FAILED				4004


#define MAX_LOG_WRITE_COUNT 4
typedef struct tagDecLogWrite
{
	int iSize;
	int iLogType;
	int iCount;
	char cParam[MAX_LOG_WRITE_COUNT][LEN_64];
}DecLogWrite, *PDecLogWrite;

typedef struct tagDecCtrlMac
{
	int iSize;
	int iDevId;
	int iCardId;
	int iNetId;			//
	char cPcMac[LEN_64];	  
}DecCtrlMac, *PDecCtrlMac;

#define SHOW_LAST_FRAME 1

#define DELETE_LOOOP_ITEM_EXCEPT 0
#define ADD_LOOP_ITEM_EXCEPT	 1

#define AUDIO_STATUS_CLOSE		0
#define AUDIO_STATUS_OPEN		1
#define AUDIO_STATUS_FAILD      -1
#define AUDIO_FAILD_REASON_RESERVE 0
#define AUDIO_FAILD_REASON_MUTEX   1

#define TALK_STATUS_CLOSE		0
#define TALK_STATUS_OPEN		1
#define TALK_STATUS_FAILD      -1
#define TALK_FAILD_REASON_RESERVE 0
#define TALK_FAILD_REASON_MUTEX   1

#define VIEW_STATUS_STOP		0
#define VIEW_STATUS_RUN			1

#define LOOP_STATUS_STOP		0
#define LOOP_STATUS_START		1

#define LOOP_TYPE_VIDEO		0
#define LOOP_TYPE_PLAN		1

#define EX_CHANNEL_FLAG		0x7FFFFFFF

//ErrorID
#define DEC_LASTERROR_ALARMLINK		0x13000		//ǰ޸
#define DEC_LASTERROR_MODIFY_IP		0x13100		//ipַ޸ʧ

typedef struct tagDecLastError
{
	int		iSize;			
	int		iErrorID;
	char	cErrorInfo[DEC_LEN_64]; 
} DecLastError, *pDecLastError;

typedef struct tagDecSinglePic
{
	int		iSize;	
	int		iPicNum;
	int		iState;	//״̬:0-ǵģʽ, 1-
} DecSinglePic, *pDecSinglePic;

typedef struct tagDecScreenRegion
{
	int		iSize;
	int		iEnable;		//ʹ
	int		iXPos;			//ʼ
	int		iYPos;			//ʼ
	int		iPixelWidth;	//ؿ
	int		iPixelHeight;	//ظ߶
} DecScreenRegion, *pDecScreenRegion;

typedef struct tagDecScreenBasicPara
{
	int		iSize;	
	int		iBrightness;	//ȣ0100
	int		iContrast;		//Աȶȣ0100
	int		iSaturation;	//Ͷȣ0100
	int		iHue;			//ɫȣ0100
} DecScreenBasicPara, *pDecScreenBasicPara;

#define SCREEN_OUTPUT_MODE_HDMI				0
#define SCREEN_OUTPUT_MODE_DVI				1
#define SCREEN_OUTPUT_MODE_ADAPTATION		2
typedef struct tagDecScreenOutputMode
{
	int		iSize;	
	int		iMode;		//0:HDMI 1:DVI 2:Ӧ
} DecScreenOutputMode, *pDecScreenOutputMode;

typedef struct tagDecPicLevelRelation
{
	int		iSize;
	int		iPicCount;
	int		iLevelArray[DEC_MAX_WINDOW_TOTAL_NUM];	//㼶ϵ:±Ϊţ㼶ϵײ㿪ʼΪ0μ1
			//iLevelArray[0]ǵ0Ĳ㼶iLevelArray[1]ǵ1Ĳ㼶iLevelArray[N]ǵNĲ㼶
} DecPicLevelRelation, *pDecPicLevelRelation;

typedef struct tagDecSyncLoopCtrl
{
	int		iSize;	
	int		iLoopEnable;	//0ֹͣл 1ʼл
} DecSyncLoopCtrl, *pDecSyncLoopCtrl;

typedef struct tagDecSyncLoopTime
{
	int		iSize;	
	int		iHoldTime;		//ͣʱ䣺10-999
} DecSyncLoopTime, *pDecSyncLoopTime;

typedef struct tagDecEncodePara
{
	int		iSize;	
	int		iWidth;			//Ƶ
	int		iHeight;		//Ƶ
	int		iFrameRate;		//֡ʣЧֵ1255060
	int		iBitRate;		//ʣλΪKBytes/s1024kbps
} DecEncodePara, *pDecEncodePara;

typedef struct tagDecHttpPort
{
	int		iSize;	
	int		iPort;			//HTTP˿ں
	int		iHttpsPort;		//HTTPS˿ں
	int		iRtsPort;		//˿ں 
	int		iSchedulePort;	//ڶ˿ں
} DecHttpPort, *pDecHttpPort;

typedef struct tagDecShowIcon
{
	int     iSize;
	int     iIconType;		//ͼ,1-655350-Ԥ,1-׶˺ɫ˸
	int     iDisp;			//Ƿʾ,0 ʾ 1 ʾ
} DecShowIcon, *pDecShowIcon;

typedef struct tagDecAlarmEffectLight
{
	int     iSize;
	int     iEnable;				//Чʹܣ1--ʹܣ0--ر					
	int		iDuration;				//Чʱ 	λ					
	int		iColor;					//ɫ32λȡ24λʾɫrgb, ַʽbgr[((DWORD)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))]				
	int		iFlashtime;				//˸,	λ					
} DecAlarmEffectLight, *pDecAlarmEffectLight;

#define MAX_EFFECTREGION_POINT_COUNT		8
typedef struct tagDecAlarmEffectRegion
{
	int     iSize;
	int     iEnable;				//Чʹܣ1--ʹܣ0--ر					
	int		iDuration;				//Чʱ 	λ
	int		iWidth;					//߿
	int		iColor;					//ɫ32λȡ24λʾɫrgb, ַʽbgr[((DWORD)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))]					
	int		iPointCount;			//򶥵8					
	POINT	tPoints[MAX_EFFECTREGION_POINT_COUNT];	//, Ƶֱʵֱ			
} DecAlarmEffectRegion, *pDecAlarmEffectRegion;

typedef struct tagDecAlarmEffectText
{
	int     iSize;
	int     iEnable;				//Чʹܣ1--ʹܣ0--ر					
	int		iDuration;				//Чʱ 	λ
	int		iFontSize;				//СΧ1-55С
	int		iColor;					//ɫ32λȡ24λʾɫrgb, ַʽbgr[((DWORD)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))]					
	char	cText[LEN_64];			//ı	64ֽ					
	int		iTextAlign;				//뷽ʽ0--ûԶ, 1--Ͻ, 2--½, 3--Ͻ, 4--½, 5					
	POINT	tPoint;					//ַϽ꣬Ƶֱʵֱ					
	int		iTextWidth;				//ıȣʵʷֱ					
	int		iTextHeight;			//ı߶ȣʵʷֱ					
	int		iLeft;					//߾࣬iTextAlignΪ1, 2ʱЧ					
	int		iTop;					//ϱ߾࣬iTextAlignΪ1, 3ʱЧ					
	int		iRight;					//ұ߾࣬iTextAlignΪ3, 4ʱЧ					
	int		iBottom;				//±߾࣬iTextAlignΪ2, 4ʱЧ						
} DecAlarmEffectText, *pDecAlarmEffectText;

#define DEC_MAX_PLAN_LOOP_ITEM_NUM MAX_PLAN_COUNT
typedef struct tagPlanLoopItem
{
	int     iIndex;		//лк
	int		iPlanNo;	//Ԥ
	int		iHoldTime;	//ͣʱ 30-9999
}PlanLoopItem,*pPlanLoopItem;

typedef struct tagPlanLoopList
{
	int     iCount;		//лбĿ
	PlanLoopItem tPlanLoopItem[DEC_MAX_PLAN_LOOP_ITEM_NUM];
}PlanLoopList,*pPlanLoopList;

typedef struct tagPlanLoop
{
	int     iEnable;	//ʹ
	int     iCount;     //Ŀ
	int		iIndex;	    //ǰлк
	int		iPlanNo;	//ǰԤ
}PlanLoop,*pPlanLoop;

typedef struct tagPlanLoopItemDel
{
	int		iIndex;	    //Ҫɾлк
}PlanLoopItemDel,*pPlanLoopItemDel;

//豸繤ģʽ
typedef	struct tagLanParamWorkMode
{
	int				iWorkMode;				//ģʽ0ݣ1ַ
	int				iMainLanNo;				//0Lan11Lan2
}LanParamWorkMode, *pLanParamWorkMode;

typedef struct tagSipVideoChannelEx
{
	char 	cChannelID[DEC_MAX_CHANNELID_LEN+1];
	int     iLevel;
	int     iPtzTime;
	int		iConnectMode;
	int		iTCPConnectType;
}SipVideoChannelEx, *pSipVideoChannelEx;

typedef struct tagDecChanMaxWin
{
	int     iMaxWin;
}DecChanMaxWin, *pDecChanMaxWin;

#define  DEC_MAX_LAYOUT_NUM 32
typedef struct tagDecChanLayoutList
{
	int     iLayoutNum;
	int		iLayout[DEC_MAX_LAYOUT_NUM];

}DecChanLayoutList, *pDecChanLayoutList;

#define  DEC_MAX_RESOLUTION_NUM 32
typedef struct tagDecChanResolutionList
{
	int     iResolutionNum;
	int		iResolution[DEC_MAX_RESOLUTION_NUM];
}DecChanResolutionList, *pDecChanResolutionList;

typedef struct tagPicSnap
{
	ServerItem uServerItem;
	int serType;			//0Tiandy1Onvif2push3rtsp4ڲͨ5ͨ
							//1000ʼǳҶԽ  1001LG 1002£
}PicSnap,*pPicSnap;

typedef struct tagPicSnapResult
{
	int     iRet;				//0ɹ1ʧܣ
	int     iSnapID;			//ץID
}PicSnapResult, *pPicSnapResult;

typedef struct tagPicSnapID
{
	int     iSnapID;//ץID
}PicSnapID, *pPicSnapID;

typedef struct tagPicSnapFileName
{
	int     iSnapID;
	int     iState;					//0ɹ1ʧܣ2ץ
	char    cPicFileName[LEN_256];	//ץͼƬļ
}PicSnapFileName, *pPicSnapFileName;

typedef struct tagScreenCtlProtocols
{
	int		iCount;													//Э
	char 	cProtocol[MAX_PROTOCOL_NUM][MAX_PROTOCOL_NAME_LEN32+1];	//Эƣ֧128Э飬ÿЭ32ֽڣ	
}ScreenCtlProtocols, *pScreenCtlProtocols;

typedef struct tagScreenCtlProtocol
{
	int     iScreenNo;		//ƴıţָIEʾĻ			
	int     iAddressNo;		//Ļַ0x11~0xAA				
	int     iComNo;			//ڱ
	char 	cProtocol[MAX_PROTOCOL_NAME_LEN32+1];
}ScreenCtlProtocol, *pScreenCtlProtocol;

typedef struct tagScreenCtl
{
	int     iScreenNo;		//ƴıţָIEʾĻ			
	int     iActionType;	//1ػ2ƴѡ3Աȶȣ4ȣ5ɫͶȣ6
	int     iParam;			//1ػ0-ػ1-2ƴѡʱ0-AV
							//1-S-VIDEO2-VGA3-DVI4-HDMI3ĶȿƣԱȶȡȡɫͶȡȣ0-٣1-
}ScreenCtl, *pScreenCtl;

typedef struct tagScreenCtlResult
{
	int     iScreenNo;					
	int     iActionType;	
	int     iParam; 
	int     iResult;		//0Ԥ1ɹ2ʧ
}ScreenCtlResult, *pScreenCtlResult;

typedef struct tagRebootTradeResult
{
	int       iResult;		//0Ԥ1ɹ2ʧ
}RebootTradeResult,*pRebootTradeResult;

#define DEC_MAX_VIDEOLIST_SIZE			100

typedef struct tagUDiskVideoList
{
	int      iCount;
	char 	 cVideoName[DEC_MAX_VIDEOLIST_SIZE][LEN_128];	//Ƶ	
}UDiskVideoList, *pUDiskVideoList;

typedef struct tagUDiskCurVideo
{
	int		iCurVideoState;		//Ƶ״̬
	char 	cVideoName[LEN_128];	//Ƶ	
}UDiskCurVideo, *pUDiskCurVideo;


#define DEC_MAX_UDISK_CHANNEL_VIDEO		20
typedef struct tagUDiskSetChannelVideo
{
	int		iVideoNum; //Ƶ
	char 	cVideoName[DEC_MAX_UDISK_CHANNEL_VIDEO][LEN_128];	//Ƶ	
	int     iChannelNo;
	int     iPos;
}UDiskSetChannelVideo, *pUDiskSetChannelVideo;

#define DEC_MAX_UDISK_ALL_CHANNEL_VIDEO		10
typedef struct tagUDiskAllChannelVideo
{
	int    iCount;
	UDiskSetChannelVideo tUDiskSetChannelVideo[DEC_MAX_UDISK_ALL_CHANNEL_VIDEO];
}UDiskAllChannelVideo, *pUDiskAllChannelVideo;


typedef struct tagVideoPlayMode
{
	int		iPlayMode; //ģʽƵͣ1ѭ 2˳򲥷  
}VideoPlayMode, *pVideoPlayMode;

typedef struct tagVideoPlayCmd
{
	int		iPlayCmd;  //0ֹͣ 1ʼ  
}VideoPlayCmd, *pVideoPlayCmd;

typedef struct tagVideoPlayCmdResult
{
	int			 iPlayCmd;
	int			 iResult;      //0Ԥ1ɹ2ʧ
}VideoPlayCmdResult, *pVideoPlayCmdResult;

typedef struct tagPlanLoopStatus
{
	int			 iStatus;//0ʼл 1ֹͣл
}PlanLoopStatus, *pPlanLoopStatus;

typedef struct tagLoopParam
{
	int			 iType;	//0,Ƶлб1 Ԥлб
}LoopParam, *pLoopParam;

typedef struct tagSoundCtrlResult
{
	int iAudioStatus;//0:AUDIO_STATUS_CLOSE	1:AUDIO_STATUS_OPEN	-1: AUDIO_STATUS_FAILD
	int iFailReason;//0Ԥ1ԽѴ򿪣뱾ƵԤڻ
}SoundCtrlResult;

typedef struct tagTalkServResult
{
	int iTalkStatus;//0:TALK_STATUS_CLOSE	1:TALK_STATUS_OPEN	-1:TALK_STATUS_FAILD      
	int iFailReason;//0Ԥ1ƵԤѴ򿪣Խڻ
}TalkServResult;

#endif
